package DTCDemo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import net.miginfocom.swing.MigLayout;

//====================================================================================

class ComboItem {
    private String key;
    private byte   value;

    public ComboItem(String key, byte value) {
        this.key   = key;
        this.value = value;
    }

    @Override
    public String toString() {return key;}
    public byte   getValue() {return value;}
}

//====================================================================================

@SuppressWarnings("serial")
class Main extends JPanel {

    public static JTabbedPane tabbedPane = new JTabbedPane(JTabbedPane.TOP);
    public static Printer   PrinterTab   = new Printer(tabbedPane);
    public static Info      InfoTab      = new Info();
    public static Encoding  EncodingTab  = new Encoding();
    public static Driver1   Driver1Tab   = new Driver1();
    public static Driver2   Driver2Tab   = new Driver2();
    public static PrintDemo PrintDemoTab = new PrintDemo();
    public static Utility 	UtilityTab	 = new Utility();
    
	//------------------------------------------------------------------------------------

	public Main() {
        setOpaque(true);
        setLayout(new MigLayout("", "[550px,grow]", "[700px,grow][]"));

        add(tabbedPane, "cell 0 0,grow");
        tabbedPane.addChangeListener(new ChangeListener() {
			@Override
			public void stateChanged(ChangeEvent e) {
		        String tab = tabbedPane.getTitleAt(tabbedPane.getSelectedIndex());
		        if (tab.equals(PrintDemo.PRINTDEMO_TAB_TITLE))
					PrintDemoTab.Selected();
		        else if (tab.equals(Driver1.DRIVER1_TAB_TITLE))
		        	Driver1Tab.Selected();
			}
		});
        
        JButton btnExit = new JButton("Exit");
        btnExit.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent e) {
        		System.exit(0);
        	}
        });
        add(btnExit, "cell 0 1,alignx right");
    }
}

//====================================================================================

@SuppressWarnings("serial")
public class JDemoMain extends JPanel {
	public JDemoMain() {
	}
	/**
     * Create the GUI and show it.  For thread safety, 
     * this method is invoked from the event-dispatching thread.
     */
    public static void main(String[] args) {
        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                //Create and set up the window.
                JFrame frame = new JFrame("DTC SDK Java Demo");
                frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

                //Create and set up the content pane.
				Main newContentPane = new Main();
                frame.setContentPane(newContentPane);

                //Display the window.
                frame.pack();
                frame.setVisible(true);
            }
        });
    }
}
